/*
 * Decompiled with CFR 0.152.
 */
package GameState;

import Entity.MenuOption;
import Entity.Mouse;
import GameState.GameState;
import GameState.GameStateManager;
import Handlers.Content;
import Handlers.Keys;
import Handlers.Options;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class HowToPlayState
extends GameState {
    private Font font;
    private BufferedImage howToPlay;
    private int currentChoice = 0;
    private int currentHowTo = 0;
    private String[] options = new String[]{"Back", "Prev", "Next"};
    private MenuOption mo;
    private Mouse mouse;

    public HowToPlayState(GameStateManager gsm) {
        this.gsm = gsm;
        this.font = new Font("Arial", 0, 20);
        this.howToPlay = Content.HowToControls;
        this.mo = new MenuOption(this.options, gsm.regFont, 130, 335, 130, 0);
        this.mouse = new Mouse();
        this.currentHowTo = 0;
        this.currentChoice = 0;
    }

    @Override
    public void init() {
    }

    @Override
    public void update() {
        this.handleInput();
        this.mo.update(this.mouse);
        this.mouse.update();
    }

    @Override
    public void draw(Graphics2D g) {
        g.drawImage((Image)Content.MenuBG, 0, 0, null);
        g.drawImage((Image)this.howToPlay, 0, 0, null);
        g.setFont(this.font);
        g.setColor(Color.WHITE);
        g.setFont(this.gsm.regFont);
        if (Options.getOption(5)) {
            this.mo.draw(g);
            this.mouse.draw(g);
        } else {
            int i = 0;
            while (i < this.options.length) {
                if (i == this.currentChoice) {
                    g.setColor(Color.YELLOW);
                } else {
                    g.setColor(Color.WHITE);
                }
                this.gsm.drawCenteredString(this.options[i], 260 + i * 260, 670, g);
                ++i;
            }
        }
    }

    private void select(int currentChoice) {
        if (currentChoice == 0) {
            this.gsm.setState(0);
        }
        if (currentChoice == 1) {
            --this.currentHowTo;
            if (this.currentHowTo < 0) {
                this.currentHowTo = 2;
            }
        }
        if (currentChoice == 2) {
            ++this.currentHowTo;
            if (this.currentHowTo > 2) {
                this.currentHowTo = 0;
            }
        }
        if (this.currentHowTo == 0) {
            this.howToPlay = Content.HowToControls;
        } else if (this.currentHowTo == 1) {
            this.howToPlay = Content.HowToCollectables;
        } else if (this.currentHowTo == 2) {
            this.howToPlay = Content.HowToObjectives;
        }
    }

    @Override
    public void handleInput() {
        if (Keys.isKeyPressed(Keys.ESCAPE)) {
            this.gsm.setState(0);
        }
        if (Options.getOption(5)) {
            if (Keys.isMousePressed(Keys.LEFTCLICK)) {
                this.select(this.mo.getChoice());
            }
        } else {
            if (Keys.isKeyPressed(Keys.ENTER)) {
                this.select(this.currentChoice);
            }
            if (Keys.isKeyPressed(Keys.LEFT)) {
                this.currentChoice = this.currentChoice > 0 ? --this.currentChoice : this.options.length - 1;
            }
            if (Keys.isKeyPressed(Keys.RIGHT)) {
                this.currentChoice = this.currentChoice < this.options.length - 1 ? ++this.currentChoice : 0;
            }
        }
    }
}

